function [outI1, outI2, outA1, outA2] = mirrorAugment(I1,I2,A1,A2, chanceFlip)
%MIRRORAUGMENT Flip both images left/right or 
% top/down. Chanceflip is bernoulli, chance of vert flip is independent of horz flip
    r = rand(2, 1);

    if r(1) < chanceFlip
        sx = -1;
    else
        sx = 1;
    end
    if r(2) < chanceFlip
        sy = -1;
    else
        sy = 1;
    end
    
    % create the transform
    tform = affine2d([ sx 0 0; 0 sy 0; 0 0 1]);
    view = affineOutputView(size(I1),tform,'BoundsStyle','CenterOutput');
    outI1 = imwarp(I1, tform, 'FillValue', 255, 'OutputView',view);
    outI2 = imwarp(I2, tform, 'FillValue', 255, 'OutputView',view);
    
    % apply transform to annotations
    outA1 = affineAnnotations(A1, tform);
    outA2 = affineAnnotations(A2, tform);
end

